/*
  make an html page showing alerts.
*/

#include <stdio.h>
#include <assert.h>
#include <time.h>

#include "libfma.h"
#include "lf_alert.h"
#include "lf_fms.h"

#include "insist.h"
#include "fm_cgi_util.h"

static void draw_alerts (int fms, int acked, int relics)
{
  int i, num_alerts;
  lf_string_t buf;
  struct lf_alert*alerts;

  insist (fms != -1);
  
  num_alerts = lf_fms_query_alerts (fms, acked, relics, &alerts);

  e_w (("<html>"));
  e_w (("<head>"));
  e_w (("<meta http-equiv=\"Refresh\" content=\"11\"><meta http-equiv=\"Expires\" content=\"0\"><meta http-equiv=\"Pragma\" content=\"no-cache\">"));
  
  e_w (("</head>"));

  e_w (("<body>"));
  e_w (("<form id=show_alerts action=\"%s\" method=POST>", "fm_cgi_ack_alerts.cgi"));


  e_w (("<script language=\"javascript\">"));
  e_w (("  function check (c, v)"));
  e_w (("  {"));
  e_w (("    for (i = 0; i < c.length; i++)"));
  e_w (("      c [i].checked = v;"));
  e_w (("  }"));
  e_w (("</script>"));


  e_w (("<table border=0>"));
  e_w (("<tr><th></th><th> id </th> <th> time </th> <th> state </th> <th> description </th></tr>"));
  
  for (i = 0; i < num_alerts; i++)
  {
    struct lf_alert*ap = &alerts [i];

    e_w (("<tr>"));

    e_w (("<td><input type=checkbox name=id value=%d></td>", ap->alert_id));

    /* alert ID */
    e_w (("<td>%d</td>", ap->alert_id));

    /* print alert time */
    {
      char*s;
      time_t t;
      t = ap->alert_time;
      s = asctime (localtime (&t));
      s [strlen (s) - 1] = 0;
      e_w (("<td>%s</td>", s));
    }
    
    e_w (("<td>"));
    e_w (("%s%s", ap->acked ? "a" : "", ap->relic ? "r" : ""));
    e_w (("</td>"));
    lf_alert_string (buf, ap);

    e_w (("<td>%s</td>", buf));
    e_w (("</tr>"));
  }
  e_w (("</table>"));

  e_w (("<input type=button value=\"Check All\" onClick=\"check(document.getElementById ('show_alerts').id, true);\">"));
  e_w (("<input type=button value=\"Uncheck All\" onClick=\"check(document.getElementById ('show_alerts').id, false);\">"));
  e_w (("<br><input type=submit name=submit value=Ack>"));

  e_w (("</form>"));

  e_w (("</html>"));
  except:;
}

int main (int argc, char*argv [])
{
  int fms = -1;
  int acked, relics;

  lf_init();

  printf ("Content-type: text/html\n\n");


  acked = fm_cgi_query_yes ("acked");
  relics = fm_cgi_query_yes ("relics");
  
  fms = fm_cgi_connect_to_fms ();
  insistf (fms != -1, ("error connecting to fms"));
  

  draw_alerts (fms, acked, relics);
  
  lf_fms_disconnect (fms);
  
  return 0;
  except: return 1;
}
